package gov.va.med.mhv.bluebutton.web.bean;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang3.StringUtils;

public class StudyImageInfo implements Serializable {
	private static final long serialVersionUID = -1694898992157594161L;
	
	private static final String URIBASE="/mhvapi/v1/bluebutton/external/studyjob/image/studyidUrn/{studyIdUrn}/series/{series}/image/{image}";
	private static final String UNAVAILABLE="/mhv-bluebutton-portal-portlet/resources/img/bbmi_unavailable.jpg";

	private int index;
	private String caption;
	private String uri;
	boolean showUnavailable;
	int imageNo;
	int imageTtl;
	
	public StudyImageInfo(int imageNo, int imageTtl, String file, String studyIdUrn, boolean imageViewable) {
		this.caption = file.replace(".jpg", "");  // Remove the file name extension
		this.caption = "Image " + imageNo + " of " + imageTtl + "  (" + this.caption + ")";
		
		//Series 1001 - Image 01.jpg
		Pattern pattern = Pattern.compile("Series (?<series>[0-9a-zA-Z]+) - Image (?<image>[0-9a-zA-Z]+).+");
		
		Matcher m = pattern.matcher(file);

		String image = null,series = null;
		if (m.matches()) {
		    series = m.group("series");
		    image = m.group("image");
		}

		if( series == null || image == null ) {
			imageViewable = false;
		}
		
		this.showUnavailable=!imageViewable;
		if( showUnavailable ){
			this.uri = UNAVAILABLE;
		}
		else {
			String localuri = StringUtils.replace(URIBASE, "{studyIdUrn}", studyIdUrn);
			localuri = StringUtils.replace(localuri, "{series}", series);
			localuri = StringUtils.replace(localuri, "{image}", image);
			this.uri = localuri;
		}
	}

	public int getIndex() {
		return index;
	}

	public String getCaption() {
		return caption;
	}

	public String getUri() {
		return uri;
	}

	public boolean isShowUnavailable() {
		return showUnavailable;
	}

}
